#include "SavedConnection.h"
#include <string.h>

SavedConnection::SavedConnection():informations(10)
{
	this->length = 0;
}

SavedConnection::SavedConnection(int capacity):informations(capacity)
{
	this->length = 0;
}

SavedConnection::~SavedConnection()
{
}

SavedConnection::SavedConnection(const SavedConnection& source):informations(source.informations)
{
	this->length = source.length;
}

SavedConnection& SavedConnection::operator=(const SavedConnection& source)
{
	this->informations = source.informations;
	this->length = source.length;

	return (*this);
}

Information& SavedConnection::operator[](int index)
{
	return (this->informations)[index];
}

Information* SavedConnection::operator++(int)
{
	return (this->informations)++;
}

Information* SavedConnection::operator--(int)
{
	return (this->informations)--;
}

Information* SavedConnection::operator+(int index)
{
	return (this->informations)+index;
}

Information* SavedConnection::operator-(int index)
{
	return (this->informations)-index;
}

int SavedConnection::RecordInformation(Information& information)
{
	int ret = 0;

	ret = this->informations.AppendFromRear(information);

	if( ret == this->length ){
		(this->length)++;
		ret = 1;				// Success to record
	}

	else{
		ret = 0;				// Fail to record
	}

	return ret;
}

int SavedConnection::FindInformationByTitle(QString& title)
{
	int ret = -1;

	ret = this->informations.LinearSearchUnique(&title, CompareByTitle);

	return ret;
}

int SavedConnection::EraseInformation(int index)
{
	int ret = 0;
	
	ret = this->informations.Delete(index);

	if( ret == -1 ){
		(this->length)--;
	}

	return ret;
}

int SavedConnection::CorrectInformation(int index, Information& information)
{
	int ret = 0;

	ret = this->informations.Modify(index, information);

	return ret;
}

int CompareByTitle(void* one, void* other)
{
	int ret = 0;

	if(((Information*)one)->GetTitle() ==  *((QString*)other)){
		ret = 0;
	}

	else{// if((((Information*)one)->GetTitle().toStdString() != ((QString*)other)->toStdString())){
		ret = -1;
	}
/*
	else if((((Information*)one)->GetTitle().toStdString() == ((QString*)other)->toStdString())){
		ret = -1;
	}
*/

	return ret;
}
